<?php
include_once 'db.php';

// Start a transaction
mysqli_begin_transaction($conn);

try {
    // Get action type and product IDs from POST data
    $action = isset($_POST['action']) ? $_POST['action'] : null;
    $productids = isset($_POST['productid']) ? $_POST['productid'] : '';

    // Validate inputs
    if (empty($action) || empty($productids)) {
        throw new Exception("Missing required parameters.");
    }

    // Sanitize and prepare the array of product IDs
    $productids = array_map('intval', explode(',', $productids));

    // Prepare SQL query based on action type
    if ($action === 'online') {
        $sql = "UPDATE product SET mode = '1' WHERE Product_id IN (" . implode(',', $productids) . ")";
    } elseif ($action === 'offline') {
        $sql = "UPDATE product SET mode = '0' WHERE Product_id IN (" . implode(',', $productids) . ")";
    } elseif ($action === 'delete') {
        $sql = "UPDATE product SET delete_status = '1' WHERE Product_id IN (" . implode(',', $productids) . ")";
    } else {
        throw new Exception("Invalid action type.");
    }

    // Execute the query
    $result = mysqli_query($conn, $sql);

    if (!$result) {
        throw new Exception("Error updating records: " . mysqli_error($conn));
    }

    // Commit the transaction
    mysqli_commit($conn);
    echo json_encode(["status" => "success", "message" => "Records updated successfully."]);
} catch (Exception $e) {
    // Rollback on error
    mysqli_rollback($conn);
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    // Close the conn
    mysqli_close($conn);
}
?>
